/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.action;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.services.RepositoryService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import de.willuhn.util.I18N;
import java.net.MalformedURLException;
import java.net.URL;

public class RepositoryAdd
implements Action {
    @Override
    public void handleAction(Object context) throws ApplicationException {
        I18N i18n = Application.getI18n();
        String url = null;
        try {
            String s = i18n.tr("Bitte geben Sie die URL des Repository ein") + ":";
            url = Application.getCallback().askUser(s, i18n.tr("Neue URL"));
            if (url == null || url.length() == 0) {
                return;
            }
            URL u = new URL(url);
            RepositoryService service = (RepositoryService)Application.getBootLoader().getBootable(RepositoryService.class);
            service.addRepository(u);
        }
        catch (OperationCanceledException s) {
        }
        catch (MalformedURLException e) {
            throw new ApplicationException(i18n.tr("Ung\u00fcltige URL: {0}", url));
        }
        catch (ApplicationException ae) {
            throw ae;
        }
        catch (Exception e) {
            Logger.error((String)("error while adding url " + context), (Throwable)e);
            Application.getMessagingFactory().sendMessage(new StatusBarMessage(i18n.tr("Fehler beim Hinzuf\u00fcgen der Repository-URL"), 1));
        }
    }
}

